/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.SkullBlockRendererAccessor;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CustomHeadLayer.class})
public abstract class CustomHeadLayerMixin<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    private ItemInHandRenderer itemInHandRenderer;
    @Shadow
    @Final
    private Map<SkullBlock.Type, SkullModelBase> skullModels;

    public CustomHeadLayerMixin(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, cancellable=true)
    private void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        BlockItem block;
        ArmorItem armorItem;
        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getEquipmentSlot() == EquipmentSlot.HEAD) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatar(livingEntity);
        if (!RenderUtils.vanillaModel(avatar)) {
            return;
        }
        if (avatar.luaRuntime != null && !avatar.luaRuntime.vanilla_model.HELMET_ITEM.checkVisible()) {
            ci.cancel();
            return;
        }
        Item item2 = itemStack.getItem();
        if (item2 instanceof BlockItem && (block = (BlockItem)item2).getBlock() instanceof AbstractSkullBlock) {
            RenderType renderType;
            SkullBlock.Type type;
            SkullModelBase skullModelBase;
            ResolvableProfile gameProfile = null;
            if (itemStack.getComponents().has(DataComponents.PROFILE)) {
                gameProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
            }
            if (avatar.pivotPartRender(ParentType.HelmetItemPivot, arg_0 -> CustomHeadLayerMixin.lambda$render$0(itemStack, livingEntity, f, multiBufferSource, i, skullModelBase = this.skullModels.get(type = ((AbstractSkullBlock)((BlockItem)itemStack.getItem()).getBlock()).getType()), renderType = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)gameProfile), arg_0))) {
                ci.cancel();
            }
        } else if (avatar.pivotPartRender(ParentType.HelmetItemPivot, stack -> {
            float s = 10.0f;
            stack.translate(0.0, 4.0, 0.0);
            stack.scale(s, s, s);
            this.itemInHandRenderer.renderItem(livingEntity, itemStack, ItemDisplayContext.HEAD, false, stack, multiBufferSource, i);
        })) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/SkullBlockRenderer;renderSkull(Lnet/minecraft/core/Direction;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/model/SkullModelBase;Lnet/minecraft/client/renderer/RenderType;)V")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    private void renderSkull(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        SkullBlockRendererAccessor.setItem(livingEntity.getItemBySlot(EquipmentSlot.HEAD));
        SkullBlockRendererAccessor.setEntity(livingEntity);
        SkullBlockRendererAccessor.setRenderMode(SkullBlockRendererAccessor.SkullRenderMode.HEAD);
    }

    private static /* synthetic */ void lambda$render$0(ItemStack itemStack, LivingEntity livingEntity, float f, MultiBufferSource multiBufferSource, int i, SkullModelBase skullModelBase, RenderType renderType, PoseStack stack) {
        float s = 19.0f;
        stack.scale(s, s, s);
        stack.translate(-0.5, 0.0, -0.5);
        SkullBlockRendererAccessor.setItem(itemStack);
        SkullBlockRendererAccessor.setEntity((Entity)livingEntity);
        SkullBlockRendererAccessor.setRenderMode(SkullBlockRendererAccessor.SkullRenderMode.HEAD);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)f, (PoseStack)stack, (MultiBufferSource)multiBufferSource, (int)i, (SkullModelBase)skullModelBase, (RenderType)renderType);
    }
}

